<?php
session_start();

// Als het formulier is ingediend, controleer de CAPTCHA invoer
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $captchaInput = $_POST['captcha'];
    
    // Valideer de CAPTCHA (in dit voorbeeld is het correcte antwoord "250")
    if ($captchaInput === '250') {
        $_SESSION['captcha_passed'] = true;  // Stel sessie variabele in als CAPTCHA correct is
        header('Location: index.php');  // Redirect naar index.php
        exit();
    } else {
        $error = "Onjuiste CAPTCHA, probeer het opnieuw.";
    }
}
?>

<!DOCTYPE html>
<html lang="nl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>CAPTCHA Verificatie</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            margin: 0;
            position: relative;
        }

        /* Banner bovenaan */
        .banner {
            position: fixed;
            top: 0;
            left: 0;
            height: .5rem;
            background-image: linear-gradient(to right, #aa418c, #ff9300);
            width: 100%;
            z-index: 9999; /* Zorg dat de banner boven alles komt */
        }

        /* Banner onderaan */
        .banner-bottom {
            position: fixed;
            bottom: 0;
            left: 0;
            height: .5rem;
            background-image: linear-gradient(to right, #aa418c, #ff9300);
            width: 100%;
            z-index: 9999;
        }

        /* KVK rechtsboven */
        .kvk-title {
            position: fixed;
            top: 10px;
            right: 10px;
            text-align: right;
            color: #00526e;
            font-size: 2.5rem;
            line-height: 3rem;
            font-weight: 800;
            font-family: Arial, sans-serif;
            z-index: 10000; /* Zorg dat KVK altijd zichtbaar blijft */
        }

        .captcha-container {
            background-color: #fff;
            border-radius: 10px;
            box-shadow: 0 0 15px rgba(0, 0, 0, 0.1);
            padding: 20px;
            width: 260px;
            text-align: center;
        }
        .captcha-container h1 {
            font-size: 1rem;
            color: #333;
            
        }
        .captcha-container img {
            width: 180px;  /* Maak de afbeelding smaller */
            margin-bottom: 15px;
            border-radius: 5px;
        }
        .captcha-container input[type="text"] {
            width: 180px;  /* Maak het tekstvak smaller */
            padding: 8px;
            font-size: 14px;
            border: 1px solid #ddd;
            border-radius: 5px;
            margin-bottom: 15px;
        }
        .captcha-container button {
            width: 100%;
            padding: 10px;
            font-size: 16px;
            background-color: #00526e;
            color: white;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            transition: background-color 0.3s ease;
        }
        .captcha-container button:hover {
            background-color: #00426e;
        }
        .captcha-container .error {
            color: red;
            font-size: 14px;
            margin-top: 10px;
        }
        .captcha-container .controls {
            margin-top: 15px;
        }
        .captcha-container .controls button {
            background-color: transparent;
            border: none;
            cursor: pointer;
            font-size: 1.2rem;
            margin: 0 5px;
        }
        .captcha-container .controls button:hover {
            color: #4CAF50;
        }
    </style>
</head>
<body>
    <!-- Banner bovenaan de pagina -->
    <div class="banner"></div>

    <!-- Banner onderaan de pagina -->
    <div class="banner-bottom"></div>

    <!-- KVK rechtsboven in de hoek -->
    

    <div class="captcha-container">

        <h1>Bevestig dat je geen robot bent</h1>
        <img src="captcha.png" alt="CAPTCHA">
        <form method="POST" action="captcha.php">
            <input type="text" name="captcha" placeholder="Typ het woord hierboven" required>
            <button type="submit">Verifiëren</button>
        </form>
        <?php
        if (isset($error)) {
            echo '<div class="error">' . $error . '</div>';
        }
        ?>

    </div>
</body>
</html>
